/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.terraform;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.BothMaskElement;
import com.moulberry.axiom.mask.elements.NotMaskElement;
import com.moulberry.axiom.mask.elements.SolidMaskElement;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.terraform.ClentaminatorDecorationPlacer;
import com.moulberry.axiom.tools.terraform.ClentaminatorPaintjob;
import com.moulberry.axiom.tools.terraform.SingleClentaminatorPaintjob;
import com.moulberry.axiom.tools.terraform.decoration.ClearDecorationPlacer;
import com.moulberry.axiom.tools.terraform.decoration.CropsDecorationPlacer;
import com.moulberry.axiom.tools.terraform.decoration.FlowerDecorationPlacer;
import com.moulberry.axiom.tools.terraform.decoration.GrassyDecorationPlacer;
import com.moulberry.axiom.tools.terraform.terrain.DirtGroundTerrainPaintjob;
import com.moulberry.axiom.tools.terraform.terrain.FarmlandTerrainPaintjob;
import com.moulberry.axiom.tools.terraform.terrain.FertileOceanFloorTerrainPaintjob;
import com.moulberry.axiom.tools.terraform.terrain.GrassTerrainPaintjob;
import com.moulberry.axiom.tools.terraform.terrain.GravelGroundTerrainPaintjob;
import com.moulberry.axiom.tools.terraform.terrain.SandTerrainPaintjob;
import com.moulberry.axiom.utils.NbtGetter;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import java.text.NumberFormat;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2202;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class ClentaminatorTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private boolean painting = false;
    private AsyncToolPathProvider pathProvider = null;
    private ClentaminatorPaintjob terrainPaintjob = null;
    private ClentaminatorDecorationPlacer decorationPlacer = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private boolean doTerrain = true;
    private final int[] terrainType = new int[]{0};
    private boolean doDecoration = true;
    private final int[] decorationType = new int[]{0};
    private final FarmlandTerrainPaintjob.Settings farmlandSettings = new FarmlandTerrainPaintjob.Settings();
    private final GrassyDecorationPlacer.Settings grassySettings = new GrassyDecorationPlacer.Settings();
    private final CropsDecorationPlacer.Settings cropsSettings = new CropsDecorationPlacer.Settings();

    @Override
    public void reset() {
        if (this.painting) {
            this.painting = false;
            ChunkRenderOverrider.INSTANCE.release("clentaminator");
        }
        this.terrainPaintjob = null;
        this.decorationPlacer = null;
        this.chunkedBlockRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.reset();
                if (!this.painting) {
                    this.painting = true;
                    ChunkRenderOverrider.INSTANCE.acquire("clentaminator");
                }
                this.pathProvider = new AsyncToolPathProvider(this.createToolPather(this.brushWidget.getBrushShape()));
                if (this.doTerrain) {
                    switch (this.terrainType[0]) {
                        default: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new SingleClentaminatorPaintjob(class_2246.field_10340.method_9564());
                            break;
                        }
                        case 1: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new GrassTerrainPaintjob();
                            break;
                        }
                        case 2: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new SandTerrainPaintjob();
                            break;
                        }
                        case 3: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new DirtGroundTerrainPaintjob();
                            break;
                        }
                        case 4: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new GravelGroundTerrainPaintjob();
                            break;
                        }
                        case 5: {
                            ClentaminatorPaintjob clentaminatorPaintjob = new FertileOceanFloorTerrainPaintjob();
                            break;
                        }
                        case 6: {
                            ClentaminatorPaintjob clentaminatorPaintjob = this.terrainPaintjob = new FarmlandTerrainPaintjob(this.farmlandSettings);
                        }
                    }
                }
                if (this.doDecoration) {
                    this.decorationPlacer = switch (this.decorationType[0]) {
                        default -> new ClearDecorationPlacer();
                        case 1 -> new GrassyDecorationPlacer(this.grassySettings);
                        case 2 -> new CropsDecorationPlacer(this.cropsSettings, this.terrainPaintjob instanceof FarmlandTerrainPaintjob);
                        case 3 -> new FlowerDecorationPlacer();
                    };
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.painting) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.painting) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
        } else if (Tool.cancelUsing()) {
            this.reset();
        } else if (!Tool.isMouseDown(1)) {
            class_2487 sourceInfo = Tool.getSourceInfo(this);
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, sourceInfo);
            this.reset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
        }
    }

    private AsyncToolPather createToolPather(BrushShape brushShape) {
        class_638 level = class_310.method_1551().field_1687;
        MaskElement destMask = MaskManager.getDestMask();
        BothMaskElement placeableMask = new BothMaskElement(destMask, new NotMaskElement(new SolidMaskElement()));
        MaskElement sourceMask = MaskManager.getSourceMask();
        MaskContext maskContext = new MaskContext((class_1937)level);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
            class_2680 newState;
            if (!destMask.test(maskContext.reset(), x, y, z)) {
                return;
            }
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (blockState.method_26204() == class_2246.field_10243) {
                return;
            }
            if (ClentaminatorTool.isDecorationBlock(blockState)) {
                if (this.decorationPlacer != null) {
                    class_2680 below;
                    if (this.decorationPlacer instanceof ClearDecorationPlacer) {
                        class_2680 clear = blockState.method_26227().method_15759();
                        this.chunkedBlockRegion.addBlockIfNotPresent(x, y, z, clear);
                        ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, class_2246.field_10124.method_9564());
                    } else if (blockState.method_45474() && sourceMask.test(maskContext.reset(), x, y - 1, z) && !ClentaminatorTool.isDecorationBlock(below = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y - 1, z)))) {
                        this.decorationPlacer.place((class_1922)level, this.chunkedBlockRegion, placeableMask, maskContext, x, y, z);
                    }
                }
            } else if (this.terrainPaintjob != null && (newState = this.terrainPaintjob.paint((class_1922)level, blockState, x, y, z)) != null) {
                this.chunkedBlockRegion.addBlock(x, y, z, newState);
                class_265 shape1 = newState.method_26202((class_1922)class_2682.field_12294, class_2338.field_10980, class_3726.method_16194());
                class_265 shape2 = blockState.method_26202((class_1922)level, (class_2338)mutableBlockPos, class_3726.method_16194());
                if (class_259.method_1074((class_265)shape1, (class_265)shape2, (class_247)class_247.field_16893)) {
                    ChunkRenderOverrider.INSTANCE.setBlock(x, y, z, newState);
                }
            }
        });
    }

    public static boolean isDecorationBlock(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return !blockState.method_51366() || blockState.method_26164(class_3481.field_15475) || blockState.method_26164(class_3481.field_20340) || blockState.method_26164(class_3481.field_20340) || block instanceof class_2397 || block instanceof class_2211 || block instanceof class_2202;
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
        this.brushWidget.displayImgui();
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.clentaminator.terrain"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.clentaminator.terrain"), this.doTerrain)) {
            boolean bl = this.doTerrain = !this.doTerrain;
        }
        if (this.doTerrain) {
            ImGuiHelper.combo("##TerrainCombo", this.terrainType, new String[]{AxiomI18n.get("axiom.tool.clentaminator.stone"), AxiomI18n.get("axiom.tool.clentaminator.grass"), AxiomI18n.get("axiom.tool.clentaminator.sand"), AxiomI18n.get("axiom.tool.clentaminator.dirt_ground"), AxiomI18n.get("axiom.tool.clentaminator.gravel_ground"), AxiomI18n.get("axiom.tool.clentaminator.fertile_ocean_floor"), AxiomI18n.get("axiom.tool.clentaminator.farmland")});
            switch (this.terrainType[0]) {
                case 6: {
                    this.farmlandSettings.displayImGuiOptionsWithBorder();
                    break;
                }
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.clentaminator.decorations"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.clentaminator.decorations"), this.doDecoration)) {
            boolean bl = this.doDecoration = !this.doDecoration;
        }
        if (this.doDecoration) {
            ImGuiHelper.combo("##DecorationsCombo", this.decorationType, new String[]{AxiomI18n.get("axiom.tool.clentaminator.clear"), AxiomI18n.get("axiom.tool.clentaminator.grass"), AxiomI18n.get("axiom.tool.clentaminator.crops")});
            switch (this.decorationType[0]) {
                case 1: {
                    this.grassySettings.displayImGuiOptionsWithBorder();
                    break;
                }
                case 2: {
                    this.cropsSettings.displayImGuiOptionsWithBorder();
                    break;
                }
            }
        }
    }

    @Override
    public String listenForEsc() {
        if (!this.painting) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.clentaminator");
    }

    @Override
    public void writeSourceInfo(class_2487 tag, boolean includeSettings) {
        tag.method_10582("SourceName", "Clentaminator Tool");
        if (includeSettings) {
            class_2487 settings = new class_2487();
            this.writeSettings(settings);
            tag.method_10566("SourceSettings", (class_2520)settings);
        }
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10556("DoTerrain", this.doTerrain);
        tag.method_10569("TerrainType", this.terrainType[0]);
        tag.method_10556("DoDecoration", this.doDecoration);
        tag.method_10569("DecorationType", this.decorationType[0]);
        this.farmlandSettings.writeSettings(tag);
        this.grassySettings.writeSettings(tag);
        this.cropsSettings.writeSettings(tag);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.doTerrain = NbtGetter.getBoolOrDefault(tag, "DoTerrain", true);
        this.terrainType[0] = NbtGetter.getIntOrDefault(tag, "TerrainType", 0);
        this.doDecoration = NbtGetter.getBoolOrDefault(tag, "DoDecoration", true);
        this.decorationType[0] = NbtGetter.getIntOrDefault(tag, "DecorationType", 0);
    }

    @Override
    public char iconChar() {
        return '\ue90d';
    }

    @Override
    public String keybindId() {
        return "clentaminator";
    }
}

